<?php

use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\CheckoutController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PaymentsController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

// Public site
Route::get('/', [HomeController::class, 'index'])->name('home');
Route::get('/hosting', [HomeController::class, 'hosting'])->name('hosting');
Route::get('/domain', [HomeController::class, 'domain'])->name('domain');

// Auth
Route::get('/login', [LoginController::class, 'show'])->name('login');
Route::post('/login', [LoginController::class, 'login'])->name('login.submit');
Route::get('/register', [RegisterController::class, 'show'])->name('register');
Route::post('/register', [RegisterController::class, 'register'])->name('register.submit');
Route::post('/logout', function () {
    Auth::logout();
    request()->session()->invalidate();
    request()->session()->regenerateToken();
    return redirect()->route('home');
})->name('logout');

// One-page checkout
Route::get('/checkout', [CheckoutController::class, 'show'])->name('checkout.show');
Route::post('/checkout', [CheckoutController::class, 'submit'])->name('checkout.submit');

// Payment returns/webhooks (PayPal/Stripe/etc)
Route::get('/payments/{gateway}/return', [PaymentsController::class, 'handleReturn'])->name('payments.return');
Route::get('/payments/{gateway}/cancel', [PaymentsController::class, 'cancel'])->name('payments.cancel');
Route::post('/payments/{gateway}/webhook', [PaymentsController::class, 'webhook'])->name('payments.webhook');

// Client area
Route::middleware('auth')->prefix('client')->name('client.')->group(function () {
    Route::get('/dashboard', [\App\Http\Controllers\Client\DashboardController::class, 'index'])->name('dashboard');

    Route::get('/invoices', [\App\Http\Controllers\Client\InvoicesController::class, 'index'])->name('invoices.index');
    Route::get('/invoices/{invoice}', [\App\Http\Controllers\Client\InvoicesController::class, 'show'])->name('invoices.show');
    Route::post('/invoices/{invoice}/pay', [\App\Http\Controllers\Client\InvoicesController::class, 'pay'])->name('invoices.pay');
});

// Admin area
Route::middleware('auth')->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [\App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('dashboard');

    Route::get('/clients', [\App\Http\Controllers\Admin\ClientsController::class, 'index'])->name('clients.index');
    Route::get('/clients/{client}', [\App\Http\Controllers\Admin\ClientsController::class, 'show'])->name('clients.show');

    Route::get('/plans', [\App\Http\Controllers\Admin\PlansController::class, 'index'])->name('plans.index');
    Route::get('/plans/create', [\App\Http\Controllers\Admin\PlansController::class, 'create'])->name('plans.create');
    Route::post('/plans', [\App\Http\Controllers\Admin\PlansController::class, 'store'])->name('plans.store');
    Route::get('/plans/{plan}/edit', [\App\Http\Controllers\Admin\PlansController::class, 'edit'])->name('plans.edit');
    Route::put('/plans/{plan}', [\App\Http\Controllers\Admin\PlansController::class, 'update'])->name('plans.update');

    Route::get('/invoices', [\App\Http\Controllers\Admin\InvoicesController::class, 'index'])->name('invoices.index');
    Route::get('/invoices/{invoice}', [\App\Http\Controllers\Admin\InvoicesController::class, 'show'])->name('invoices.show');
    Route::post('/invoices/{invoice}/mark-paid', [\App\Http\Controllers\Admin\InvoicesController::class, 'markPaid'])->name('invoices.mark_paid');

    Route::get('/support-pin', [\App\Http\Controllers\Admin\SupportPinController::class, 'showForm'])->name('support_pin.form');
    Route::post('/support-pin', [\App\Http\Controllers\Admin\SupportPinController::class, 'lookup'])->name('support_pin.lookup');

    // Plugins
    Route::get('/plugins', [\App\Http\Controllers\Admin\PluginsController::class, 'index'])->name('plugins.index');
    Route::post('/plugins/upload', [\App\Http\Controllers\Admin\PluginsController::class, 'upload'])->name('plugins.upload');
    Route::post('/plugins/{slug}/enable', [\App\Http\Controllers\Admin\PluginsController::class, 'enable'])->name('plugins.enable');
    Route::post('/plugins/{slug}/disable', [\App\Http\Controllers\Admin\PluginsController::class, 'disable'])->name('plugins.disable');
    Route::post('/plugins/{slug}/migrate', [\App\Http\Controllers\Admin\PluginsController::class, 'migrate'])->name('plugins.migrate');
    Route::post('/plugins/{slug}/settings', [\App\Http\Controllers\Admin\PluginsController::class, 'saveSettings'])->name('plugins.settings');
});

// Boot enabled plugins (routes/hooks/gateways)
\App\Services\Plugins\PluginLoader::boot();
