<nav class="navbar navbar-expand-lg navbar-light bg-white border-bottom sticky-top">
    <div class="container">
        <a class="navbar-brand fw-semibold" href="{{ route('home') }}">{{ config('clubhoster.brand.name', 'ClubHoster') }}</a>

        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                <li class="nav-item"><a class="nav-link" href="{{ route('hosting') }}">Hosting</a></li>
                <li class="nav-item"><a class="nav-link" href="{{ route('domain') }}">Domains</a></li>
                <li class="nav-item"><a class="nav-link" href="{{ route('checkout.show') }}">Order Now</a></li>
            </ul>

            <div class="d-flex gap-2 align-items-center">
                @auth
                    <a class="btn btn-outline-primary btn-sm" href="{{ route('client.dashboard') }}">Client Area</a>
                    @if(auth()->user()->is_admin)
                        <a class="btn btn-outline-dark btn-sm" href="{{ route('admin.dashboard') }}">Admin</a>
                    @endif

                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <button class="btn btn-primary btn-sm" type="submit">Logout</button>
                    </form>
                @else
                    <a class="btn btn-outline-primary btn-sm" href="{{ route('login') }}">Login</a>
                    <a class="btn btn-primary btn-sm" href="{{ route('checkout.show') }}">Sign Up & Buy</a>
                @endauth
            </div>
        </div>
    </div>
</nav>
