<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ config('clubhoster.brand.name', 'ClubHoster') }} - @yield('title', 'Web Hosting & Domains')</title>

    <link rel="icon" href="/favicon.ico">

    <!-- Fonts: Poppins -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Bootstrap (CDN) -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" crossorigin="anonymous">

    <!-- Existing theme CSS -->
    <link rel="stylesheet" href="/style.css">
    <link rel="stylesheet" href="/css/clubhoster-app.css">

    @stack('head')
</head>
<body>
    @include('partials.public_nav')

    <main class="py-4">
        <div class="container">
            @if(session('success'))
                <div class="alert alert-success ch-alert">{{ session('success') }}</div>
            @endif
            @if(session('error'))
                <div class="alert alert-danger ch-alert">{{ session('error') }}</div>
            @endif
            @if ($errors->any())
                <div class="alert alert-danger ch-alert">
                    <div class="fw-semibold mb-1">Please fix the highlighted fields:</div>
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
        </div>

        @yield('content')
    </main>

    <footer class="py-5" style="background: #0b1220; color:#fff;">
        <div class="container">
            <div class="row g-4">
                <div class="col-md-6">
                    <div class="fw-semibold fs-4">{{ config('clubhoster.brand.name', 'ClubHoster') }}</div>
                    <div class="text-white-50">Friendly hosting, simple billing, fast checkout.</div>
                </div>
                <div class="col-md-6 text-md-end">
                    <div class="text-white-50">Support: {{ config('clubhoster.brand.support_email', 'support@example.com') }}</div>
                    <div class="text-white-50">&copy; {{ date('Y') }} {{ config('clubhoster.brand.name', 'ClubHoster') }}</div>
                </div>
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
    @stack('scripts')
</body>
</html>
