<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin Panel - {{ config('clubhoster.brand.name', 'ClubHoster') }}</title>

    <link rel="icon" href="/favicon.ico">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" crossorigin="anonymous">
    <link rel="stylesheet" href="/style.css">
    <link rel="stylesheet" href="/css/clubhoster-app.css">
</head>
<body class="ch-bg">
    <div class="d-flex">
        <aside class="ch-sidebar">
            <div class="ch-sidebar-title">{{ config('clubhoster.brand.name', 'ClubHoster') }}</div>
            <div class="ch-muted small mb-3">Admin Panel</div>

            <a class="ch-side-link" href="{{ route('admin.dashboard') }}">Dashboard</a>
            <a class="ch-side-link" href="{{ route('admin.clients.index') }}">Clients</a>
            <a class="ch-side-link" href="{{ route('admin.invoices.index') }}">Invoices</a>
            <a class="ch-side-link" href="{{ route('admin.plans.index') }}">Plans</a>
            <a class="ch-side-link" href="{{ route('admin.support_pin.form') }}">Support PIN Lookup</a>
            <a class="ch-side-link" href="{{ route('admin.plugins.index') }}">Plugins</a>

            <div class="mt-3 pt-3 border-top">
                <a class="btn btn-sm btn-outline-light w-100" href="{{ route('client.dashboard') }}">Client Area</a>
                <div class="mt-2">
                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <button class="btn btn-sm btn-outline-light w-100" type="submit">Logout</button>
                    </form>
                </div>
            </div>
        </aside>

        <main class="flex-grow-1">
            <div class="ch-topbar">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <div class="fw-semibold">Admin: {{ auth()->user()->name }}</div>
                        <div class="text-muted small">Support PIN: <span class="badge text-bg-primary">{{ auth()->user()->support_pin }}</span></div>
                    </div>
                    <div class="d-flex gap-2">
                        <a class="btn btn-outline-primary btn-sm" href="{{ route('home') }}">Website</a>
                    </div>
                </div>
            </div>

            <div class="container py-4">
                @if(session('success'))
                    <div class="alert alert-success ch-alert">{{ session('success') }}</div>
                @endif
                @if(session('error'))
                    <div class="alert alert-danger ch-alert">{{ session('error') }}</div>
                @endif
                @if ($errors->any())
                    <div class="alert alert-danger ch-alert">
                        <ul class="mb-0">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                @yield('content')
            </div>
        </main>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
</body>
</html>
