@extends('layouts.public')

@section('title', 'Fast Web Hosting & Easy Billing')

@section('content')
    <div class="ch-hero">
        <div class="container">
            <div class="row align-items-center g-4">
                <div class="col-lg-6">
                    <div class="ch-badge mb-3">One Page Checkout • Domain + Hosting • JazzCash</div>
                    <h1 class="display-5 fw-semibold">Launch your website fast with <span style="color:var(--ch-primary)">{{ config('clubhoster.brand.name', 'ClubHoster') }}</span></h1>
                    <p class="lead text-muted">A friendly billing area, modern admin panel, and simple purchase flow from signup to payment.</p>

                    <div class="d-flex flex-wrap gap-2">
                        <a class="btn btn-primary btn-lg" href="{{ route('checkout.show') }}">Sign Up & Buy Now</a>
                        <a class="btn btn-outline-primary btn-lg" href="{{ route('hosting') }}">View Hosting Plans</a>
                    </div>

                    <div class="mt-4 text-muted">
                        <div class="small">Included:</div>
                        <ul class="mb-0">
                            <li>Unique Support PIN for every customer (shown in billing area)</li>
                            <li>One-page domain + hosting purchase</li>
                            <li>JazzCash MWallet integrated (refined in one place)</li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="ch-card p-4">
                        <div class="fw-semibold mb-2">Quick Domain Search</div>
                        <form class="row g-2" method="GET" action="{{ route('checkout.show') }}">
                            <div class="col-8">
                                <input class="form-control" name="domain" placeholder="example.com" required>
                            </div>
                            <div class="col-4 d-grid">
                                <button class="btn btn-primary" type="submit">Continue</button>
                            </div>
                            <div class="col-12">
                                <div class="text-muted small">Type domain once — it stays selected on checkout.</div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="container mt-5">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h2 class="fw-semibold mb-0">Popular Hosting Plans</h2>
            <a class="text-decoration-none" href="{{ route('hosting') }}">See all</a>
        </div>

        <div class="row g-3">
            @foreach($plans as $plan)
                <div class="col-md-4">
                    <div class="ch-plan">
                        <div class="d-flex justify-content-between align-items-start">
                            <div>
                                <div class="ch-plan-title">{{ $plan->name }}</div>
                                <div class="ch-muted">{{ $plan->description }}</div>
                            </div>
                            <div class="text-end">
                                <div class="fs-4 fw-semibold">PKR {{ number_format((float)$plan->price_monthly, 0) }}</div>
                                <div class="ch-muted small">/ month</div>
                            </div>
                        </div>

                        <div class="mt-3">
                            <ul class="small mb-0">
                                @foreach(($plan->features ?? []) as $feat)
                                    <li>{{ $feat }}</li>
                                @endforeach
                            </ul>
                        </div>

                        <div class="mt-3 d-grid">
                            <a class="btn btn-primary" href="{{ route('checkout.show', ['plan' => $plan->id]) }}">Choose Plan</a>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
@endsection
