@extends('layouts.public')

@section('title', 'Hosting Plans')

@section('content')
    <div class="container mt-4">
        <h1 class="fw-semibold">Hosting Plans</h1>
        <p class="text-muted">Pick a package and checkout in one page (domain + hosting + signup + JazzCash).</p>

        <div class="row g-3">
            @foreach($plans as $plan)
                <div class="col-md-4">
                    <div class="ch-plan">
                        <div class="ch-plan-title">{{ $plan->name }}</div>
                        <div class="ch-muted">{{ $plan->description }}</div>

                        <div class="mt-3 d-flex justify-content-between align-items-center">
                            <div>
                                <div class="fs-4 fw-semibold">PKR {{ number_format((float)$plan->price_monthly, 0) }}</div>
                                <div class="ch-muted small">per month</div>
                            </div>
                            <div class="text-end">
                                <div class="fw-semibold">PKR {{ number_format((float)$plan->price_yearly, 0) }}</div>
                                <div class="ch-muted small">per year</div>
                            </div>
                        </div>

                        <div class="mt-3">
                            <ul class="small mb-0">
                                @foreach(($plan->features ?? []) as $feat)
                                    <li>{{ $feat }}</li>
                                @endforeach
                            </ul>
                        </div>

                        <div class="mt-3 d-grid">
                            <a class="btn btn-primary" href="{{ route('checkout.show', ['plan' => $plan->id]) }}">Buy Now</a>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
@endsection
