@extends('layouts.public')

@section('title', 'Domains')

@section('content')
    <div class="container mt-4">
        <h1 class="fw-semibold">Domains</h1>
        <p class="text-muted">Search your domain and continue to checkout. Domain stays selected.</p>

        <div class="ch-card p-4 mb-4">
            <form class="row g-2" method="GET" action="{{ route('checkout.show') }}">
                <div class="col-md-8">
                    <input class="form-control" name="domain" value="{{ $domain ?? '' }}" placeholder="example.com" required>
                </div>
                <div class="col-md-4 d-grid">
                    <button class="btn btn-primary" type="submit">Continue to Checkout</button>
                </div>
            </form>
        </div>

        <h2 class="fw-semibold">Popular TLD Pricing (Yearly)</h2>
        <div class="row g-3">
            @foreach($tlds as $tld)
                <div class="col-md-3">
                    <div class="ch-card p-3">
                        <div class="fw-semibold">{{ $tld->tld }}</div>
                        <div class="text-muted">PKR {{ number_format((float)$tld->price_yearly, 0) }} / year</div>
                    </div>
                </div>
            @endforeach
        </div>

        <div class="text-muted small mt-3">Note: Domain registration/transfer can be processed automatically once a registrar API is connected. The current build supports manual processing + tracking from admin panel.</div>
    </div>
@endsection
