@extends('layouts.client')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-3">
        <div>
            <h1 class="fw-semibold mb-0">Invoice {{ $invoice->number }}</h1>
            <div class="text-muted">Status: <span class="badge text-bg-{{ $invoice->status === 'paid' ? 'success' : ($invoice->status === 'unpaid' ? 'warning' : 'secondary') }}">{{ $invoice->status }}</span></div>
        </div>
        <a class="btn btn-outline-primary" href="{{ route('client.invoices.index') }}">Back</a>
    </div>

    <div class="row g-3">
        <div class="col-lg-7">
            <div class="ch-card p-4">
                <div class="fw-semibold mb-2">Items</div>

                <div class="table-responsive">
                    <table class="table table-sm align-middle">
                        <thead>
                            <tr>
                                <th>Description</th>
                                <th class="text-end">Qty</th>
                                <th class="text-end">Unit</th>
                                <th class="text-end">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($invoice->items as $item)
                                <tr>
                                    <td>{{ $item->description }}</td>
                                    <td class="text-end">{{ $item->qty }}</td>
                                    <td class="text-end">{{ $invoice->currency }} {{ number_format((float)$item->unit_price, 2) }}</td>
                                    <td class="text-end">{{ $invoice->currency }} {{ number_format((float)$item->total, 2) }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="3" class="text-end">Subtotal</th>
                                <th class="text-end">{{ $invoice->currency }} {{ number_format((float)$invoice->subtotal, 2) }}</th>
                            </tr>
                            <tr>
                                <th colspan="3" class="text-end">Tax</th>
                                <th class="text-end">{{ $invoice->currency }} {{ number_format((float)$invoice->tax, 2) }}</th>
                            </tr>
                            <tr>
                                <th colspan="3" class="text-end">Total</th>
                                <th class="text-end">{{ $invoice->currency }} {{ number_format((float)$invoice->total, 2) }}</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>

            <div class="ch-card p-4 mt-3">
                <div class="fw-semibold mb-2">Transactions</div>
                <div class="table-responsive">
                    <table class="table table-sm align-middle">
                        <thead>
                            <tr>
                                <th>Gateway</th>
                                <th>Ref</th>
                                <th>Status</th>
                                <th class="text-end">Amount</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($invoice->transactions()->latest()->get() as $txn)
                                <tr>
                                    <td>{{ $txn->gateway }}</td>
                                    <td>{{ $txn->txn_ref ?? '-' }}</td>
                                    <td>{{ $txn->status }}</td>
                                    <td class="text-end">{{ $txn->currency }} {{ number_format((float)$txn->amount, 2) }}</td>
                                    <td>{{ $txn->created_at }}</td>
                                </tr>
                            @empty
                                <tr><td colspan="5" class="text-muted">No transactions yet.</td></tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="col-lg-5">
            <div class="ch-card p-4">
                <div class="fw-semibold mb-2">Payment</div>

                @if($invoice->status === 'paid')
                    <div class="alert alert-success">This invoice is already paid.</div>
                @elseif(empty($gateways))
                    <div class="alert alert-warning">No payment gateways are configured. Please contact support.</div>
                @else
                    <form method="POST" action="{{ route('client.invoices.pay', $invoice) }}">
                        @csrf

                        <div class="row g-2 mb-3">
                            @foreach($gateways as $idx => $gw)
                                <div class="col-12">
                                    <label class="ch-option w-100">
                                        <input type="radio" name="payment_gateway" value="{{ $gw->slug() }}" @checked(old('payment_gateway', $gateways[0]->slug()) === $gw->slug())>
                                        <div>
                                            <div class="fw-semibold">{{ $gw->displayName() }}</div>
                                            <div class="text-muted small">Secure online payment</div>
                                        </div>
                                    </label>
                                </div>
                            @endforeach
                        </div>

                        @foreach($gateways as $gw)
                            @php $fields = $gw->checkoutFields(); @endphp
                            <div class="ch-gateway-fields" data-gateway="{{ $gw->slug() }}" style="display:none;">
                                @if(!empty($fields))
                                    @foreach($fields as $f)
                                        @php
                                            $key = $f['key'] ?? '';
                                            $label = $f['label'] ?? $key;
                                            $type = $f['type'] ?? 'text';
                                            $placeholder = $f['placeholder'] ?? '';
                                            $help = $f['help'] ?? '';
                                        @endphp
                                        <div class="mb-2">
                                            <label class="form-label">{{ $label }}</label>
                                            <input class="form-control" name="{{ $key }}" type="{{ $type }}" value="{{ old($key) }}" placeholder="{{ $placeholder }}">
                                            @if($help)
                                                <div class="text-muted small mt-1">{{ $help }}</div>
                                            @endif
                                        </div>
                                    @endforeach
                                @else
                                    <div class="text-muted small">No additional information required. You will be redirected to complete the payment.</div>
                                @endif
                            </div>
                        @endforeach

                        <div class="d-grid mt-3">
                            <button class="btn btn-primary btn-lg" type="submit">Pay Now</button>
                        </div>
                    </form>

                    <div class="text-muted small mt-3">If payment fails, you can retry here without creating a new order.</div>
                @endif
            </div>

            <div class="ch-card p-4 mt-3">
                <div class="fw-semibold mb-2">Support PIN</div>
                <div class="display-6 fw-semibold">{{ auth()->user()->support_pin }}</div>
                <div class="text-muted small">Share this PIN in live chat for fast verification.</div>
            </div>
        </div>
    </div>

<script>
(function () {
    function toggleGatewayFields() {
        var selected = document.querySelector('input[name="payment_gateway"]:checked');
        var gw = selected ? selected.value : null;
        document.querySelectorAll('.ch-gateway-fields').forEach(function (el) {
            el.style.display = (gw && el.getAttribute('data-gateway') === gw) ? '' : 'none';
        });
    }

    document.addEventListener('change', function (e) {
        if (e.target && e.target.name === 'payment_gateway') {
            toggleGatewayFields();
        }
    });

    toggleGatewayFields();
})();
</script>
@endsection
