@extends('layouts.client')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="fw-semibold mb-0">Invoices</h1>
        <a class="btn btn-primary" href="{{ route('checkout.show') }}">Order new</a>
    </div>

    <div class="ch-card p-3">
        <div class="table-responsive">
            <table class="table align-middle mb-0">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Status</th>
                        <th>Due Date</th>
                        <th>Total</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($invoices as $invoice)
                        <tr>
                            <td>{{ $invoice->number }}</td>
                            <td>
                                <span class="badge text-bg-{{ $invoice->status === 'paid' ? 'success' : ($invoice->status === 'unpaid' ? 'warning' : 'secondary') }}">{{ $invoice->status }}</span>
                            </td>
                            <td>{{ $invoice->due_date ?? '-' }}</td>
                            <td>{{ $invoice->currency }} {{ number_format((float)$invoice->total, 2) }}</td>
                            <td class="text-end"><a class="btn btn-sm btn-outline-primary" href="{{ route('client.invoices.show', $invoice) }}">View</a></td>
                        </tr>
                    @empty
                        <tr><td colspan="5" class="text-muted">No invoices found.</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="mt-3">
        {{ $invoices->links() }}
    </div>
@endsection
