@extends('layouts.client')

@section('content')
    <div class="row g-3">
        <div class="col-md-4">
            <div class="ch-card p-4">
                <div class="text-muted small">Your Support PIN</div>
                <div class="display-6 fw-semibold">{{ $user->support_pin }}</div>
                <div class="text-muted small mt-1">Share this PIN during live chat so admin can verify you quickly.</div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="ch-card p-4">
                <div class="text-muted small">Active Services</div>
                <div class="display-6 fw-semibold">{{ $services->where('status','active')->count() }}</div>
                <div class="text-muted small mt-1">Hosting and other services.</div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="ch-card p-4">
                <div class="text-muted small">Unpaid Invoices</div>
                <div class="display-6 fw-semibold">{{ $user->invoices()->where('status','unpaid')->count() }}</div>
                <div class="text-muted small mt-1">Pay invoices to activate services.</div>
            </div>
        </div>
    </div>

    <div class="row g-3 mt-1">
        <div class="col-lg-7">
            <div class="ch-card p-4">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <div class="fw-semibold">Your Services</div>
                    <a class="text-decoration-none" href="{{ route('checkout.show') }}">Order new</a>
                </div>

                <div class="table-responsive">
                    <table class="table table-sm align-middle">
                        <thead>
                            <tr>
                                <th>Type</th>
                                <th>Plan</th>
                                <th>Domain</th>
                                <th>Status</th>
                                <th>Next Due</th>
                            </tr>
                        </thead>
                        <tbody>
                        @forelse($services as $service)
                            <tr>
                                <td>{{ ucfirst($service->type) }}</td>
                                <td>{{ $service->plan?->name ?? '-' }}</td>
                                <td>{{ $service->domain?->domain ?? '-' }}</td>
                                <td><span class="badge text-bg-{{ $service->status === 'active' ? 'success' : ($service->status === 'pending' ? 'warning' : 'secondary') }}">{{ $service->status }}</span></td>
                                <td>{{ $service->next_due_date ?? '-' }}</td>
                            </tr>
                        @empty
                            <tr><td colspan="5" class="text-muted">No services yet.</td></tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="col-lg-5">
            <div class="ch-card p-4">
                <div class="d-flex justify-content-between align-items-center mb-2">
                    <div class="fw-semibold">Latest Invoices</div>
                    <a class="text-decoration-none" href="{{ route('client.invoices.index') }}">View all</a>
                </div>

                <div class="table-responsive">
                    <table class="table table-sm align-middle">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Status</th>
                                <th>Total</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                        @forelse($invoices as $invoice)
                            <tr>
                                <td>{{ $invoice->number }}</td>
                                <td><span class="badge text-bg-{{ $invoice->status === 'paid' ? 'success' : ($invoice->status === 'unpaid' ? 'warning' : 'secondary') }}">{{ $invoice->status }}</span></td>
                                <td>{{ $invoice->currency }} {{ number_format((float)$invoice->total, 2) }}</td>
                                <td class="text-end">
                                    <a class="btn btn-sm btn-outline-primary" href="{{ route('client.invoices.show', $invoice) }}">Open</a>
                                </td>
                            </tr>
                        @empty
                            <tr><td colspan="4" class="text-muted">No invoices yet.</td></tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
