@extends('layouts.public')

@section('title', 'One Page Checkout')

@section('content')
<div class="container mt-4">
    <div class="row g-4">
        <div class="col-lg-7">
            <div class="ch-card p-4">
                <h1 class="fw-semibold mb-1">One Page Checkout</h1>
                <p class="text-muted mb-0">Domain + Hosting + Signup + Payment — in a single flow.</p>
            </div>

            <form class="mt-3" method="POST" action="{{ route('checkout.submit') }}">
                @csrf

                <div class="ch-card p-4 mb-3">
                    <div class="ch-section-title mb-2">1) Choose Hosting Plan</div>
                    <div class="row g-2">
                        @foreach($plans as $plan)
                            <div class="col-md-6">
                                <label class="ch-option w-100">
                                    <input type="radio" name="plan_id" value="{{ $plan->id }}" @checked(old('plan_id', $selectedPlanId) == $plan->id)>
                                    <div>
                                        <div class="d-flex justify-content-between">
                                            <div class="fw-semibold">{{ $plan->name }}</div>
                                            <div class="fw-semibold">PKR {{ number_format((float)$plan->price_monthly, 0) }}/mo</div>
                                        </div>
                                        <div class="text-muted small">{{ $plan->description }}</div>
                                    </div>
                                </label>
                            </div>
                        @endforeach
                    </div>

                    <div class="mt-3">
                        <label class="form-label">Billing Cycle</label>
                        <select class="form-select" name="billing_cycle">
                            <option value="monthly" @selected(old('billing_cycle', 'monthly') === 'monthly')>Monthly</option>
                            <option value="yearly" @selected(old('billing_cycle') === 'yearly')>Yearly</option>
                        </select>
                    </div>
                </div>

                <div class="ch-card p-4 mb-3">
                    <div class="ch-section-title mb-2">2) Domain</div>

                    <div class="row g-2">
                        <div class="col-md-6">
                            <label class="form-label">Domain Option</label>
                            <select class="form-select" name="domain_option" id="domain_option">
                                <option value="register" @selected(old('domain_option', 'register') === 'register')>Register new domain</option>
                                <option value="transfer" @selected(old('domain_option') === 'transfer')>Transfer domain</option>
                                <option value="use_own" @selected(old('domain_option') === 'use_own')>I already own a domain</option>
                                <option value="none" @selected(old('domain_option') === 'none')>Skip for now</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Domain Name</label>
                            <input class="form-control" name="domain_name" id="domain_name" value="{{ old('domain_name', $domain) }}" placeholder="example.com">
                            <div class="text-muted small mt-1">Add domain once — it stays selected.</div>
                        </div>
                        <div class="col-md-6" id="domain_years_wrap">
                            <label class="form-label">Registration Years</label>
                            <select class="form-select" name="domain_years">
                                @for($i=1; $i<=5; $i++)
                                    <option value="{{ $i }}" @selected((int)old('domain_years', 1) === $i)>{{ $i }} year(s)</option>
                                @endfor
                            </select>
                        </div>
                    </div>
                </div>

                @guest
                <div class="ch-card p-4 mb-3">
                    <div class="ch-section-title mb-2">3) Create Your Account</div>
                    <div class="row g-2">
                        <div class="col-md-6">
                            <label class="form-label">Full Name</label>
                            <input class="form-control" name="name" value="{{ old('name') }}" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Email</label>
                            <input class="form-control" name="email" type="email" value="{{ old('email') }}" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Password</label>
                            <input class="form-control" name="password" type="password" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Confirm Password</label>
                            <input class="form-control" name="password_confirmation" type="password" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Phone</label>
                            <input class="form-control" name="phone" value="{{ old('phone') }}" placeholder="03xxxxxxxxx">
                        </div>
                    </div>
                    <div class="text-muted small mt-2">After signup, your unique Support PIN will be shown in your billing dashboard for live chat verification.</div>
                </div>
                @endguest

                <div class="ch-card p-4 mb-3">
                    <div class="ch-section-title mb-2">4) Payment</div>

                    @if(empty($gateways))
                        <div class="alert alert-warning mb-0">
                            No payment gateways are configured. Please configure at least one gateway from Admin → Plugins.
                        </div>
                    @else
                        <div class="row g-2 mb-3">
                            @foreach($gateways as $idx => $gw)
                                <div class="col-md-6">
                                    <label class="ch-option w-100">
                                        <input type="radio" name="payment_gateway" value="{{ $gw->slug() }}" @checked(old('payment_gateway', $gateways[0]->slug()) === $gw->slug())>
                                        <div>
                                            <div class="fw-semibold">{{ $gw->displayName() }}</div>
                                            <div class="text-muted small">Secure online payment</div>
                                        </div>
                                    </label>
                                </div>
                            @endforeach
                        </div>

                        @foreach($gateways as $gw)
                            @php $fields = $gw->checkoutFields(); @endphp
                            <div class="ch-gateway-fields" data-gateway="{{ $gw->slug() }}" style="display:none;">
                                @if(!empty($fields))
                                    <div class="row g-2">
                                        @foreach($fields as $f)
                                            @php
                                                $key = $f['key'] ?? '';
                                                $label = $f['label'] ?? $key;
                                                $type = $f['type'] ?? 'text';
                                                $placeholder = $f['placeholder'] ?? '';
                                                $help = $f['help'] ?? '';
                                            @endphp
                                            <div class="col-md-6">
                                                <label class="form-label">{{ $label }}</label>
                                                <input class="form-control" name="{{ $key }}" type="{{ $type }}" value="{{ old($key) }}" placeholder="{{ $placeholder }}">
                                                @if($help)
                                                    <div class="text-muted small mt-1">{{ $help }}</div>
                                                @endif
                                            </div>
                                        @endforeach
                                    </div>
                                @else
                                    <div class="text-muted small">No additional information required. You will be redirected to complete the payment.</div>
                                @endif
                            </div>
                        @endforeach

                        <div class="text-muted small mt-2">If you select PayPal or Stripe, you will be redirected to complete payment and return automatically.</div>
                    @endif
                </div>

                <div class="d-grid">
                    <button class="btn btn-primary btn-lg" type="submit">Complete Order & Pay</button>
                </div>
            </form>
        </div>

        <div class="col-lg-5">
            <div class="ch-card p-4">
                <div class="ch-section-title mb-2">Checkout Notes</div>
                <ul class="small mb-0">
                    <li>One page checkout: select plan, add domain, create account, and pay.</li>
                    <li>After payment, you will be redirected to your Client Area automatically.</li>
                    <li>If payment fails, you can retry from your Invoice page.</li>
                    <li>Payment gateways and automations can be extended via Plugins.</li>
                </ul>
            </div>

            <div class="ch-card p-4 mt-3">
                <div class="ch-section-title mb-2">TLD Pricing (Yearly)</div>
                <div class="row g-2">
                    @foreach($tlds as $tld)
                        <div class="col-6">
                            <div class="border rounded-3 p-2">
                                <div class="fw-semibold">{{ $tld->tld }}</div>
                                <div class="text-muted small">PKR {{ number_format((float)$tld->price_yearly, 0) }}</div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>

<script>
(function () {
    function toggleDomainYears() {
        var opt = document.getElementById('domain_option');
        var wrap = document.getElementById('domain_years_wrap');
        if (!opt || !wrap) return;
        wrap.style.display = (opt.value === 'register') ? '' : 'none';
    }

    function toggleGatewayFields() {
        var selected = document.querySelector('input[name="payment_gateway"]:checked');
        var gw = selected ? selected.value : null;
        document.querySelectorAll('.ch-gateway-fields').forEach(function (el) {
            el.style.display = (gw && el.getAttribute('data-gateway') === gw) ? '' : 'none';
        });
    }

    document.addEventListener('change', function (e) {
        if (e.target && e.target.id === 'domain_option') {
            toggleDomainYears();
        }
        if (e.target && e.target.name === 'payment_gateway') {
            toggleGatewayFields();
        }
    });

    toggleDomainYears();
    toggleGatewayFields();
})();
</script>
@endsection
