@extends('layouts.public')

@section('title', 'Login')

@section('content')
<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="ch-card p-4">
                <h1 class="fw-semibold mb-1">Login</h1>
                <p class="text-muted">Access your Client Area.</p>

                <form method="POST" action="{{ route('login.submit') }}">
                    @csrf
                    <div class="mb-3">
                        <label class="form-label">Email</label>
                        <input class="form-control" name="email" type="email" value="{{ old('email') }}" required autofocus>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Password</label>
                        <input class="form-control" name="password" type="password" required>
                    </div>
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" name="remember" id="remember" @checked(old('remember'))>
                        <label class="form-check-label" for="remember">Remember me</label>
                    </div>

                    <div class="d-grid">
                        <button class="btn btn-primary btn-lg" type="submit">Login</button>
                    </div>
                </form>

                <div class="mt-3 text-center">
                    <a href="{{ route('checkout.show') }}" class="text-decoration-none">No account? Sign up & buy</a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
