@extends('layouts.admin')

@section('content')
    <h1 class="fw-semibold mb-3">Support PIN Lookup</h1>

    <div class="ch-card p-4">
        <form class="row g-2" method="POST" action="{{ route('admin.support_pin.lookup') }}">
            @csrf
            <div class="col-md-6">
                <label class="form-label">Support PIN</label>
                <input class="form-control" name="pin" value="{{ old('pin') }}" placeholder="e.g. 123456" required>
            </div>
            <div class="col-md-6 d-flex align-items-end">
                <button class="btn btn-primary" type="submit">Verify</button>
            </div>
        </form>

        @if(isset($client))
            <hr>
            <div class="fw-semibold mb-2">Client Found</div>
            <div>Name: {{ $client->name }}</div>
            <div>Email: <a href="{{ route('admin.clients.show', $client) }}">{{ $client->email }}</a></div>
            <div>Support PIN: <span class="badge text-bg-primary">{{ $client->support_pin }}</span></div>
        @endif
    </div>
@endsection
