@extends('layouts.admin')

@section('title', 'Plugins')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
    <h1 class="h4 mb-0">Plugins</h1>
</div>

@if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
@endif
@if(session('error'))
    <div class="alert alert-danger">{{ session('error') }}</div>
@endif

<div class="ch-card p-4 mb-3">
    <div class="fw-semibold mb-2">Upload Plugin (.zip)</div>
    <form method="POST" action="{{ route('admin.plugins.upload') }}" enctype="multipart/form-data" class="row g-2 align-items-end">
        @csrf
        <div class="col-md-8">
            <input class="form-control" type="file" name="zip" accept="application/zip,.zip" required>
        </div>
        <div class="col-md-4">
            <button class="btn btn-primary w-100" type="submit">Install Plugin</button>
        </div>
    </form>
    <div class="text-muted small mt-2">ZIP must contain exactly one top-level folder with <code>plugin.json</code> and <code>bootstrap.php</code>.</div>
</div>

<div class="ch-card p-0">
    <div class="table-responsive">
        <table class="table table-hover mb-0 align-middle">
            <thead class="table-light">
                <tr>
                    <th>Plugin</th>
                    <th>Type</th>
                    <th>Version</th>
                    <th>Status</th>
                    <th class="text-end">Actions</th>
                </tr>
            </thead>
            <tbody>
            @forelse($plugins as $row)
                @php
                    /** @var \App\Services\Plugins\PluginManifest $manifest */
                    $manifest = $row['manifest'];
                    /** @var \App\Models\Plugin|null $record */
                    $record = $row['record'];
                    $enabled = $record?->is_enabled ? true : false;
                @endphp
                <tr>
                    <td>
                        <div class="fw-semibold">{{ $manifest->name }}</div>
                        <div class="text-muted small">{{ $manifest->slug }}</div>
                        @if($manifest->description)
                            <div class="text-muted small">{{ $manifest->description }}</div>
                        @endif
                    </td>
                    <td><span class="badge text-bg-secondary">{{ $manifest->type }}</span></td>
                    <td>{{ $manifest->version }}</td>
                    <td>
                        @if($enabled)
                            <span class="badge text-bg-success">Enabled</span>
                        @else
                            <span class="badge text-bg-warning">Disabled</span>
                        @endif
                    </td>
                    <td class="text-end">
                        <div class="d-inline-flex gap-2">
                            @if(!$enabled)
                                <form method="POST" action="{{ route('admin.plugins.enable', $manifest->slug) }}">
                                    @csrf
                                    <button class="btn btn-sm btn-outline-success" type="submit">Enable</button>
                                </form>
                            @else
                                <form method="POST" action="{{ route('admin.plugins.disable', $manifest->slug) }}">
                                    @csrf
                                    <button class="btn btn-sm btn-outline-danger" type="submit">Disable</button>
                                </form>
                            @endif

                            <form method="POST" action="{{ route('admin.plugins.migrate', $manifest->slug) }}">
                                @csrf
                                <button class="btn btn-sm btn-outline-primary" type="submit">Run Migrations</button>
                            </form>
                        </div>
                    </td>
                </tr>

                @if(!empty($manifest->configFields))
                <tr>
                    <td colspan="5" class="bg-light">
                        <div class="p-3">
                            <div class="fw-semibold mb-2">Settings</div>
                            <form method="POST" action="{{ route('admin.plugins.settings', $manifest->slug) }}" class="row g-2">
                                @csrf

                                @foreach($manifest->configFields as $field)
                                    @php
                                        $key = $field['key'] ?? '';
                                        $label = $field['label'] ?? $key;
                                        $type = $field['type'] ?? 'text';
                                        $placeholder = $field['placeholder'] ?? '';
                                        $options = $field['options'] ?? [];
                                        $encrypted = (bool)($field['encrypted'] ?? false);

                                        $current = null;
                                        if($record) {
                                            $setting = $record->settings->firstWhere('key', $key);
                                            $current = $setting?->getValue();
                                        }
                                    @endphp

                                    @if($type === 'select')
                                        <div class="col-md-4">
                                            <label class="form-label">{{ $label }}</label>
                                            <select class="form-select" name="{{ $key }}">
                                                @foreach($options as $optValue => $optLabel)
                                                    <option value="{{ $optValue }}" @selected((string)$current === (string)$optValue)>{{ $optLabel }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    @elseif($type === 'password')
                                        <div class="col-md-4">
                                            <label class="form-label">{{ $label }}</label>
                                            <input class="form-control" type="password" name="{{ $key }}" placeholder="{{ $current ? '•••••• (leave blank to keep)' : $placeholder }}">
                                            @if($encrypted)
                                                <div class="text-muted small">Leave blank to keep existing secret.</div>
                                            @endif
                                        </div>
                                    @else
                                        <div class="col-md-4">
                                            <label class="form-label">{{ $label }}</label>
                                            <input class="form-control" type="text" name="{{ $key }}" value="{{ $current }}" placeholder="{{ $placeholder }}">
                                        </div>
                                    @endif
                                @endforeach

                                <div class="col-12">
                                    <button class="btn btn-sm btn-primary" type="submit">Save Settings</button>
                                </div>
                            </form>
                        </div>
                    </td>
                </tr>
                @endif

            @empty
                <tr><td colspan="5" class="text-muted p-4">No plugins found in <code>/plugins</code> directory.</td></tr>
            @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection
