@extends('layouts.admin')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="fw-semibold mb-0">Plans</h1>
        <a class="btn btn-primary" href="{{ route('admin.plans.create') }}">Add Plan</a>
    </div>

    <div class="ch-card p-3">
        <div class="table-responsive">
            <table class="table align-middle mb-0">
                <thead>
                <tr>
                    <th>Name</th>
                    <th>Slug</th>
                    <th class="text-end">Monthly</th>
                    <th class="text-end">Yearly</th>
                    <th>Active</th>
                    <th></th>
                </tr>
                </thead>
                <tbody>
                @forelse($plans as $plan)
                    <tr>
                        <td>{{ $plan->name }}</td>
                        <td class="text-muted">{{ $plan->slug }}</td>
                        <td class="text-end">PKR {{ number_format((float)$plan->price_monthly, 0) }}</td>
                        <td class="text-end">PKR {{ number_format((float)$plan->price_yearly, 0) }}</td>
                        <td>{{ $plan->is_active ? 'Yes' : 'No' }}</td>
                        <td class="text-end">
                            <a class="btn btn-sm btn-outline-primary" href="{{ route('admin.plans.edit', $plan) }}">Edit</a>
                        </td>
                    </tr>
                @empty
                    <tr><td colspan="6" class="text-muted">No plans yet.</td></tr>
                @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="mt-3">
        {{ $plans->links() }}
    </div>
@endsection
