@extends('layouts.admin')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="fw-semibold mb-0">Edit Plan</h1>
        <a class="btn btn-outline-primary" href="{{ route('admin.plans.index') }}">Back</a>
    </div>

    <div class="ch-card p-4">
        <form method="POST" action="{{ route('admin.plans.update', $plan) }}">
            @csrf
            @method('PUT')
            @include('admin.plans._form', ['plan' => $plan])
            <div class="d-grid mt-3">
                <button class="btn btn-primary btn-lg" type="submit">Update</button>
            </div>
        </form>
    </div>
@endsection
