<div class="row g-2">
    <div class="col-md-6">
        <label class="form-label">Name</label>
        <input class="form-control" name="name" value="{{ old('name', $plan->name ?? '') }}" required>
    </div>
    <div class="col-md-6">
        <label class="form-label">Slug</label>
        <input class="form-control" name="slug" value="{{ old('slug', $plan->slug ?? '') }}" placeholder="starter" required>
    </div>
    <div class="col-md-6">
        <label class="form-label">Monthly Price (PKR)</label>
        <input class="form-control" name="price_monthly" type="number" step="0.01" value="{{ old('price_monthly', $plan->price_monthly ?? '') }}" required>
    </div>
    <div class="col-md-6">
        <label class="form-label">Yearly Price (PKR)</label>
        <input class="form-control" name="price_yearly" type="number" step="0.01" value="{{ old('price_yearly', $plan->price_yearly ?? '') }}" required>
    </div>
    <div class="col-12">
        <label class="form-label">Description</label>
        <textarea class="form-control" name="description" rows="2">{{ old('description', $plan->description ?? '') }}</textarea>
    </div>
    <div class="col-12">
        <label class="form-label">Features (one per line)</label>
        <textarea class="form-control" name="features" rows="5">{{ old('features', isset($plan) && is_array($plan->features) ? implode("\n", $plan->features) : '') }}</textarea>
    </div>
    <div class="col-md-4">
        <label class="form-label">Sort Order</label>
        <input class="form-control" name="sort_order" type="number" value="{{ old('sort_order', $plan->sort_order ?? 0) }}">
    </div>
    <div class="col-md-4 d-flex align-items-end">
        <div class="form-check">
            <input class="form-check-input" type="checkbox" name="is_active" id="is_active" @checked(old('is_active', $plan->is_active ?? true))>
            <label class="form-check-label" for="is_active">Active</label>
        </div>
    </div>
</div>
