@extends('layouts.admin')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-3">
        <div>
            <h1 class="fw-semibold mb-0">Invoice {{ $invoice->number }}</h1>
            <div class="text-muted">Client: <a class="text-decoration-none" href="{{ route('admin.clients.show', $invoice->user) }}">{{ $invoice->user->email }}</a></div>
        </div>
        <a class="btn btn-outline-primary" href="{{ route('admin.invoices.index') }}">Back</a>
    </div>

    <div class="row g-3">
        <div class="col-lg-7">
            <div class="ch-card p-4">
                <div class="fw-semibold mb-2">Items</div>

                <div class="table-responsive">
                    <table class="table table-sm align-middle">
                        <thead>
                            <tr>
                                <th>Description</th>
                                <th class="text-end">Qty</th>
                                <th class="text-end">Unit</th>
                                <th class="text-end">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($invoice->items as $item)
                                <tr>
                                    <td>{{ $item->description }}</td>
                                    <td class="text-end">{{ $item->qty }}</td>
                                    <td class="text-end">{{ $invoice->currency }} {{ number_format((float)$item->unit_price, 2) }}</td>
                                    <td class="text-end">{{ $invoice->currency }} {{ number_format((float)$item->total, 2) }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th colspan="3" class="text-end">Subtotal</th>
                                <th class="text-end">{{ $invoice->currency }} {{ number_format((float)$invoice->subtotal, 2) }}</th>
                            </tr>
                            <tr>
                                <th colspan="3" class="text-end">Tax</th>
                                <th class="text-end">{{ $invoice->currency }} {{ number_format((float)$invoice->tax, 2) }}</th>
                            </tr>
                            <tr>
                                <th colspan="3" class="text-end">Total</th>
                                <th class="text-end">{{ $invoice->currency }} {{ number_format((float)$invoice->total, 2) }}</th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>

            <div class="ch-card p-4 mt-3">
                <div class="fw-semibold mb-2">Transactions</div>
                <div class="table-responsive">
                    <table class="table table-sm align-middle">
                        <thead>
                            <tr>
                                <th>Gateway</th>
                                <th>Ref</th>
                                <th>Status</th>
                                <th class="text-end">Amount</th>
                                <th>Response</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($invoice->transactions()->latest()->get() as $txn)
                                <tr>
                                    <td>{{ $txn->gateway }}</td>
                                    <td>{{ $txn->txn_ref ?? '-' }}</td>
                                    <td>{{ $txn->status }}</td>
                                    <td class="text-end">{{ $txn->currency }} {{ number_format((float)$txn->amount, 2) }}</td>
                                    <td>{{ $txn->response_code ?? '-' }}</td>
                                    <td>{{ $txn->created_at }}</td>
                                </tr>
                            @empty
                                <tr><td colspan="6" class="text-muted">No transactions.</td></tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="col-lg-5">
            <div class="ch-card p-4">
                <div class="fw-semibold mb-2">Status</div>
                <div class="mb-2">Current: <span class="badge text-bg-{{ $invoice->status === 'paid' ? 'success' : ($invoice->status === 'unpaid' ? 'warning' : 'secondary') }}">{{ $invoice->status }}</span></div>

                @if($invoice->status !== 'paid')
                    <form method="POST" action="{{ route('admin.invoices.mark_paid', $invoice) }}">
                        @csrf
                        <div class="d-grid">
                            <button class="btn btn-success" type="submit">Mark as Paid (Manual)</button>
                        </div>
                    </form>
                @else
                    <div class="alert alert-success">Paid at: {{ $invoice->paid_at ?? $invoice->updated_at }}</div>
                @endif
            </div>

            <div class="ch-card p-4 mt-3">
                <div class="fw-semibold mb-2">Client Support PIN</div>
                <div class="display-6 fw-semibold">{{ $invoice->user->support_pin }}</div>
                <div class="text-muted small">Use this for live chat verification.</div>
            </div>
        </div>
    </div>
@endsection
