@extends('layouts.admin')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="fw-semibold mb-0">Invoices</h1>

        <form class="d-flex gap-2" method="GET" action="{{ route('admin.invoices.index') }}">
            <input class="form-control" name="q" value="{{ request('q') }}" placeholder="Search invoice/user email...">
            <button class="btn btn-outline-primary" type="submit">Search</button>
        </form>
    </div>

    <div class="ch-card p-3">
        <div class="table-responsive">
            <table class="table align-middle mb-0">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Client</th>
                        <th>Status</th>
                        <th class="text-end">Total</th>
                        <th>Due</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($invoices as $inv)
                        <tr>
                            <td>{{ $inv->number }}</td>
                            <td><a class="text-decoration-none" href="{{ route('admin.clients.show', $inv->user) }}">{{ $inv->user->email }}</a></td>
                            <td>{{ $inv->status }}</td>
                            <td class="text-end">{{ $inv->currency }} {{ number_format((float)$inv->total, 2) }}</td>
                            <td>{{ $inv->due_date ?? '-' }}</td>
                            <td class="text-end"><a class="btn btn-sm btn-outline-primary" href="{{ route('admin.invoices.show', $inv) }}">Open</a></td>
                        </tr>
                    @empty
                        <tr><td colspan="6" class="text-muted">No invoices found.</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="mt-3">
        {{ $invoices->links() }}
    </div>
@endsection
