@extends('layouts.admin')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="fw-semibold mb-0">Dashboard</h1>
        <a class="btn btn-primary" href="{{ route('checkout.show') }}">Create a test order</a>
    </div>

    <div class="row g-3">
        <div class="col-md-3">
            <div class="ch-card p-4">
                <div class="text-muted small">Clients</div>
                <div class="display-6 fw-semibold">{{ $stats['clients'] }}</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="ch-card p-4">
                <div class="text-muted small">Active Services</div>
                <div class="display-6 fw-semibold">{{ $stats['active_services'] }}</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="ch-card p-4">
                <div class="text-muted small">Unpaid Invoices</div>
                <div class="display-6 fw-semibold">{{ $stats['unpaid_invoices'] }}</div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="ch-card p-4">
                <div class="text-muted small">Revenue (Paid)</div>
                <div class="display-6 fw-semibold">PKR {{ number_format((float)$stats['revenue_paid'], 0) }}</div>
            </div>
        </div>
    </div>

    <div class="row g-3 mt-1">
        <div class="col-lg-7">
            <div class="ch-card p-4">
                <div class="fw-semibold mb-2">Latest Orders</div>
                <div class="table-responsive">
                    <table class="table table-sm align-middle">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Client</th>
                                <th>Status</th>
                                <th class="text-end">Total</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($latestOrders as $order)
                                <tr>
                                    <td>{{ $order->id }}</td>
                                    <td><a class="text-decoration-none" href="{{ route('admin.clients.show', $order->user) }}">{{ $order->user->email }}</a></td>
                                    <td>{{ $order->status }}</td>
                                    <td class="text-end">{{ $order->currency }} {{ number_format((float)$order->total, 2) }}</td>
                                    <td>{{ $order->created_at }}</td>
                                </tr>
                            @empty
                                <tr><td colspan="5" class="text-muted">No orders yet.</td></tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-lg-5">
            <div class="ch-card p-4">
                <div class="fw-semibold mb-2">Latest Invoices</div>
                <div class="table-responsive">
                    <table class="table table-sm align-middle">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Status</th>
                                <th class="text-end">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($latestInvoices as $inv)
                                <tr>
                                    <td><a class="text-decoration-none" href="{{ route('admin.invoices.show', $inv) }}">{{ $inv->number }}</a></td>
                                    <td>{{ $inv->status }}</td>
                                    <td class="text-end">{{ $inv->currency }} {{ number_format((float)$inv->total, 2) }}</td>
                                </tr>
                            @empty
                                <tr><td colspan="3" class="text-muted">No invoices yet.</td></tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
