@extends('layouts.admin')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-3">
        <div>
            <h1 class="fw-semibold mb-0">{{ $client->name }}</h1>
            <div class="text-muted">{{ $client->email }}</div>
        </div>
        <a class="btn btn-outline-primary" href="{{ route('admin.clients.index') }}">Back</a>
    </div>

    <div class="row g-3">
        <div class="col-lg-5">
            <div class="ch-card p-4">
                <div class="fw-semibold mb-2">Client Profile</div>
                <div class="mb-2">Support PIN: <span class="badge text-bg-primary">{{ $client->support_pin }}</span></div>
                <div class="mb-1 text-muted small">Phone: {{ $client->phone ?? '-' }}</div>
                <div class="mb-1 text-muted small">Company: {{ $client->company ?? '-' }}</div>
                <div class="mb-1 text-muted small">Address: {{ $client->address ?? '-' }}</div>
                <div class="mb-1 text-muted small">Legacy CE ID: {{ $client->legacy_clientexec_id ?? '-' }}</div>
            </div>
        </div>
        <div class="col-lg-7">
            <div class="ch-card p-4">
                <div class="fw-semibold mb-2">Recent Invoices</div>
                <div class="table-responsive">
                    <table class="table table-sm align-middle">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Status</th>
                                <th class="text-end">Total</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($invoices as $inv)
                                <tr>
                                    <td>{{ $inv->number }}</td>
                                    <td>{{ $inv->status }}</td>
                                    <td class="text-end">{{ $inv->currency }} {{ number_format((float)$inv->total, 2) }}</td>
                                    <td class="text-end"><a class="btn btn-sm btn-outline-primary" href="{{ route('admin.invoices.show', $inv) }}">Open</a></td>
                                </tr>
                            @empty
                                <tr><td colspan="4" class="text-muted">No invoices.</td></tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="ch-card p-4 mt-3">
                <div class="fw-semibold mb-2">Services</div>
                <div class="table-responsive">
                    <table class="table table-sm align-middle">
                        <thead>
                            <tr>
                                <th>Type</th>
                                <th>Plan</th>
                                <th>Domain</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($services as $svc)
                                <tr>
                                    <td>{{ $svc->type }}</td>
                                    <td>{{ $svc->plan?->name ?? '-' }}</td>
                                    <td>{{ $svc->domain?->domain ?? '-' }}</td>
                                    <td>{{ $svc->status }}</td>
                                </tr>
                            @empty
                                <tr><td colspan="4" class="text-muted">No services.</td></tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection
