@extends('layouts.admin')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="fw-semibold mb-0">Clients</h1>

        <form class="d-flex gap-2" method="GET" action="{{ route('admin.clients.index') }}">
            <input class="form-control" name="q" value="{{ request('q') }}" placeholder="Search name/email/pin...">
            <button class="btn btn-outline-primary" type="submit">Search</button>
        </form>
    </div>

    <div class="ch-card p-3">
        <div class="table-responsive">
            <table class="table align-middle mb-0">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Support PIN</th>
                        <th>Status</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($clients as $client)
                        <tr>
                            <td>{{ $client->name }}</td>
                            <td>{{ $client->email }}</td>
                            <td><span class="badge text-bg-primary">{{ $client->support_pin }}</span></td>
                            <td>{{ $client->status ?? 'active' }}</td>
                            <td class="text-end"><a class="btn btn-sm btn-outline-primary" href="{{ route('admin.clients.show', $client) }}">Open</a></td>
                        </tr>
                    @empty
                        <tr><td colspan="5" class="text-muted">No clients found.</td></tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <div class="mt-3">
        {{ $clients->links() }}
    </div>
@endsection
