<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('plugins', function (Blueprint $table) {
            $table->id();
            $table->string('slug', 120)->unique();
            $table->string('name', 180);
            $table->string('type', 60)->default('module');
            $table->string('version', 40)->nullable();
            $table->string('author', 120)->nullable();
            $table->text('description')->nullable();
            $table->boolean('is_enabled')->default(false);
            $table->timestamp('installed_at')->nullable();
            $table->timestamps();

            $table->index(['type', 'is_enabled']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('plugins');
    }
};
