<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('invoice_id')->constrained('invoices')->cascadeOnDelete();
            $table->foreignId('user_id')->constrained('users')->cascadeOnDelete();
            $table->string('gateway', 40);
            $table->string('txn_ref', 80)->nullable();
            $table->decimal('amount', 10, 2)->default(0);
            $table->string('currency', 10)->default('PKR');
            $table->string('status', 30)->default('initiated');
            $table->string('response_code', 20)->nullable();
            $table->string('response_message', 255)->nullable();
            $table->json('raw_request')->nullable();
            $table->json('raw_response')->nullable();
            $table->timestamps();

            $table->index(['invoice_id', 'status']);
            $table->index(['txn_ref']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
