<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (!Schema::hasColumn('users', 'is_admin')) {
                $table->boolean('is_admin')->default(false)->after('password');
            }

            if (!Schema::hasColumn('users', 'support_pin')) {
                $table->string('support_pin', 12)->nullable()->unique()->after('is_admin');
            }

            if (!Schema::hasColumn('users', 'phone')) {
                $table->string('phone', 40)->nullable()->after('support_pin');
            }

            if (!Schema::hasColumn('users', 'company')) {
                $table->string('company', 120)->nullable()->after('phone');
            }

            if (!Schema::hasColumn('users', 'country')) {
                $table->string('country', 80)->nullable()->after('company');
            }

            if (!Schema::hasColumn('users', 'city')) {
                $table->string('city', 80)->nullable()->after('country');
            }

            if (!Schema::hasColumn('users', 'address')) {
                $table->string('address', 255)->nullable()->after('city');
            }

            if (!Schema::hasColumn('users', 'legacy_clientexec_id')) {
                $table->string('legacy_clientexec_id', 64)->nullable()->index()->after('address');
            }
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (Schema::hasColumn('users', 'legacy_clientexec_id')) {
                $table->dropColumn('legacy_clientexec_id');
            }
            if (Schema::hasColumn('users', 'address')) {
                $table->dropColumn('address');
            }
            if (Schema::hasColumn('users', 'city')) {
                $table->dropColumn('city');
            }
            if (Schema::hasColumn('users', 'country')) {
                $table->dropColumn('country');
            }
            if (Schema::hasColumn('users', 'company')) {
                $table->dropColumn('company');
            }
            if (Schema::hasColumn('users', 'phone')) {
                $table->dropColumn('phone');
            }
            if (Schema::hasColumn('users', 'support_pin')) {
                $table->dropUnique(['support_pin']);
                $table->dropColumn('support_pin');
            }
            if (Schema::hasColumn('users', 'is_admin')) {
                $table->dropColumn('is_admin');
            }
        });
    }
};
