<?php

return [
    // 'sandbox' or 'live'
    'environment' => env('JAZZCASH_ENV', 'sandbox'),

    // API Version for MWallet REST API
    'api_version' => env('JAZZCASH_API_VERSION', '2.0'),

    // Transaction type for MWallet
    'txn_type' => env('JAZZCASH_TXN_TYPE', 'MWALLET'),

    // Credentials
    'merchant_id' => env('JAZZCASH_MERCHANT_ID', ''),
    'password' => env('JAZZCASH_PASSWORD', ''),
    'integrity_salt' => env('JAZZCASH_INTEGRITY_SALT', ''),

    // Base URL for the REST API.
    // Common defaults:
    //  - Sandbox: https://sandbox.jazzcash.com.pk/ApplicationAPI/API
    //  - Live:    https://payments.jazzcash.com.pk/ApplicationAPI/API
    'base_url' => env('JAZZCASH_BASE_URL', null),

    // When computing pp_SecureHash, JazzCash documentation mentions SHA256 / HMAC SHA256.
    // Most working implementations for REST MWallet v2.0 use:
    //   ksort(fields); hashString = salt . '&' . implode('&', array_values(fields));
    //   pp_SecureHash = hash_hmac('sha256', hashString, salt)
    // Keep this as default unless JazzCash support instructs otherwise.
    'hash_mode' => env('JAZZCASH_HASH_MODE', 'hmac_values_prepend_salt'),

    // Expiry window for pp_TxnExpiryDateTime (minutes)
    'expiry_minutes' => (int) env('JAZZCASH_EXPIRY_MINUTES', 1440), // 1 day

    // Optional: capture raw requests/responses in logs for debugging.
    'debug_log' => (bool) env('JAZZCASH_DEBUG_LOG', false),
];
