<?php

namespace App\Support;

use App\Models\User;

class SupportPin
{
    /**
     * Generate a unique numeric support PIN for a user.
     *
     * This is intentionally user-visible and used for live chat verification.
     */
    public static function generate(int $length = 6): string
    {
        $length = max(4, min(12, $length));

        // Safety: avoid infinite loops.
        for ($i = 0; $i < 50; $i++) {
            $pin = self::randomNumeric($length);

            if (!User::query()->where('support_pin', $pin)->exists()) {
                return $pin;
            }
        }

        // Fallback: include timestamp suffix to guarantee uniqueness.
        return self::randomNumeric($length - 2) . substr((string) time(), -2);
    }

    private static function randomNumeric(int $length): string
    {
        $out = '';
        for ($i = 0; $i < $length; $i++) {
            $out .= (string) random_int(0, 9);
        }
        // Avoid leading zeros only if length>1 (preference); keep as is.
        return $out;
    }
}
