<?php

namespace App\Services\Plugins;

class PluginManifest
{
    public string $slug;
    public string $name;
    public string $type;
    public string $version;
    public ?string $author;
    public ?string $description;
    public string $path;
    public string $bootstrap;
    public array $configFields;

    public function __construct(array $data, string $path)
    {
        $this->slug = (string) ($data['slug'] ?? '');
        $this->name = (string) ($data['name'] ?? $this->slug);
        $this->type = (string) ($data['type'] ?? 'module');
        $this->version = (string) ($data['version'] ?? '1.0.0');
        $this->author = isset($data['author']) ? (string) $data['author'] : null;
        $this->description = isset($data['description']) ? (string) $data['description'] : null;
        $this->path = $path;
        $this->bootstrap = (string) ($data['bootstrap'] ?? 'bootstrap.php');
        $this->configFields = is_array($data['config_fields'] ?? null) ? (array) $data['config_fields'] : [];
    }

    public static function loadFromDirectory(string $pluginDir): ?self
    {
        $manifestPath = rtrim($pluginDir, DIRECTORY_SEPARATOR) . DIRECTORY_SEPARATOR . 'plugin.json';
        if (!is_file($manifestPath)) {
            return null;
        }

        $raw = file_get_contents($manifestPath);
        if ($raw === false) {
            return null;
        }

        $data = json_decode($raw, true);
        if (!is_array($data)) {
            return null;
        }

        $manifest = new self($data, $pluginDir);
        if ($manifest->slug === '') {
            return null;
        }

        return $manifest;
    }

    public function bootstrapPath(): string
    {
        return rtrim($this->path, DIRECTORY_SEPARATOR) . DIRECTORY_SEPARATOR . $this->bootstrap;
    }
}
