<?php

namespace App\Services\Plugins;

use App\Models\Plugin;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Schema;

class PluginLoader
{
    private static bool $booted = false;

    public static function boot(): void
    {
        if (self::$booted) {
            return;
        }
        self::$booted = true;

        try {
            if (!Schema::hasTable('plugins')) {
                return;
            }
        } catch (\Throwable $e) {
            return;
        }

        $manager = app(PluginManager::class);

        // Ensure DB is in sync with discovered plugins.
        try {
            $manager->syncDatabase();
        } catch (\Throwable $e) {
            // Ignore sync issues on bootstrap.
        }

        $manifests = $manager->discoverManifests();
        if (!$manifests) {
            return;
        }

        $enabled = Plugin::query()->where('is_enabled', true)->get();
        foreach ($enabled as $plugin) {
            $slug = $plugin->slug;
            $manifest = $manifests[$slug] ?? null;
            if (!$manifest) {
                continue;
            }

            $bootstrapPath = $manifest->bootstrapPath();
            if (!is_file($bootstrapPath)) {
                continue;
            }

            try {
                /** @var \App\Services\Plugins\PluginManifest $manifest */
                /** @var \App\Models\Plugin $plugin */
                require $bootstrapPath;
            } catch (\Throwable $e) {
                Log::error('Plugin bootstrap failed', [
                    'slug' => $slug,
                    'error' => $e->getMessage(),
                ]);
                continue;
            }
        }
    }
}
