<?php

namespace App\Services\Payments;

use App\Models\Invoice;
use Illuminate\Http\Request;

interface PaymentGatewayInterface
{
    public function slug(): string;

    public function displayName(): string;

    /**
     * Return true when the gateway has required credentials/config.
     */
    public function isConfigured(): bool;

    /**
     * Optional checkout fields (rendered on checkout and invoice payment forms).
     * Each field:
     *  - key, label, type(text|password|select), placeholder, options(optional)
     */
    public function checkoutFields(): array;

    /**
     * Laravel validation rules for checkout fields.
     */
    public function validationRules(): array;

    /**
     * Start payment for an invoice.
     * Return format:
     *  - success(bool)
     *  - message(string)
     *  - redirect_url(?string)
     */
    public function initiate(Invoice $invoice, array $data): array;

    /**
     * Handle user return/redirect after payment (if gateway uses redirects).
     */
    public function handleReturn(Request $request): array;

    /**
     * Handle server-to-server webhooks (optional).
     */
    public function handleWebhook(Request $request): array;
}
