<?php

namespace App\Services\Payments;

class GatewayRegistry
{
    private static ?self $instance = null;

    /**
     * @var array<string, PaymentGatewayInterface>
     */
    private array $gateways = [];

    public static function instance(): self
    {
        if (!self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function register(PaymentGatewayInterface $gateway): void
    {
        $slug = $gateway->slug();
        if ($slug === '') {
            return;
        }
        $this->gateways[$slug] = $gateway;
    }

    /**
     * @return array<string, PaymentGatewayInterface>
     */
    public function all(): array
    {
        return $this->gateways;
    }

    public function get(string $slug): ?PaymentGatewayInterface
    {
        return $this->gateways[$slug] ?? null;
    }
}
