<?php

namespace App\Services\Hooks;

class HookManager
{
    private static ?self $instance = null;

    public static function instance(): self
    {
        if (!self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * @var array<string, array<int, array{priority:int, cb:callable}>>
     */
    private array $hooks = [];

    public function add(string $hook, callable $callback, int $priority = 10): void
    {
        $hook = trim($hook);
        if ($hook === '') {
            return;
        }

        $this->hooks[$hook] = $this->hooks[$hook] ?? [];
        $this->hooks[$hook][] = [
            'priority' => $priority,
            'cb' => $callback,
        ];

        usort($this->hooks[$hook], fn ($a, $b) => $a['priority'] <=> $b['priority']);
    }

    public function fire(string $hook, array $payload = []): void
    {
        $hook = trim($hook);
        if ($hook === '' || empty($this->hooks[$hook])) {
            return;
        }

        foreach ($this->hooks[$hook] as $entry) {
            try {
                ($entry['cb'])($payload);
            } catch (\Throwable $e) {
                // Swallow hook errors to avoid breaking billing flows.
                // Plugins should handle their own failure modes.
            }
        }
    }
}
