<?php

namespace App\Services\Billing;

use App\Models\Invoice;
use App\Models\Transaction;
use App\Services\Hooks\HookManager;

class BillingService
{
    public function markInvoicePaid(Invoice $invoice, Transaction $transaction, array $context = []): void
    {
        // Idempotent
        if ($invoice->isPaid()) {
            return;
        }

        $invoice->update([
            'status' => 'paid',
            'paid_at' => now(),
        ]);

        if ($invoice->order) {
            $invoice->order->update(['status' => 'paid']);

            // Mark any pending services from this order as active
            $invoice->user->services()
                ->where('order_id', $invoice->order_id)
                ->where('status', 'pending')
                ->update(['status' => 'active']);
        }

        HookManager::instance()->fire('invoice.paid', [
            'invoice' => $invoice,
            'transaction' => $transaction,
            'user' => $invoice->user,
            'order' => $invoice->order,
            'context' => $context,
        ]);
    }
}
