<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'order_id',
        'type', // hosting
        'plan_id',
        'domain_id',
        'billing_cycle',
        'status',
        'next_due_date',
        'meta',
    ];

    protected $casts = [
        'next_due_date' => 'date',
        'meta' => 'array',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    public function plan()
    {
        return $this->belongsTo(Plan::class);
    }

    public function domain()
    {
        return $this->belongsTo(Domain::class);
    }
}
