<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Crypt;

class PluginSetting extends Model
{
    use HasFactory;

    protected $fillable = [
        'plugin_id',
        'key',
        'value',
        'is_encrypted',
    ];

    protected $casts = [
        'is_encrypted' => 'boolean',
    ];

    public function plugin()
    {
        return $this->belongsTo(Plugin::class);
    }

    public function getValue()
    {
        if ($this->value === null) {
            return null;
        }
        if ($this->is_encrypted) {
            try {
                return Crypt::decryptString($this->value);
            } catch (\Throwable $e) {
                return null;
            }
        }
        return $this->value;
    }

    public function setValue($plain, bool $encrypt = false): void
    {
        $this->is_encrypted = $encrypt;
        $this->value = $encrypt ? Crypt::encryptString((string) $plain) : (string) $plain;
    }
}
