<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Plugin extends Model
{
    use HasFactory;

    protected $fillable = [
        'slug',
        'name',
        'type',
        'version',
        'author',
        'description',
        'is_enabled',
        'installed_at',
    ];

    protected $casts = [
        'is_enabled' => 'boolean',
        'installed_at' => 'datetime',
    ];

    public function settings()
    {
        return $this->hasMany(PluginSetting::class);
    }

    public function setting(string $key, $default = null)
    {
        $row = $this->settings->firstWhere('key', $key);
        return $row ? $row->getValue() : $default;
    }
}
