<?php

namespace App\Http\Controllers;

use App\Models\Plan;
use App\Models\TldPricing;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function index()
    {
        $plans = Plan::query()->where('is_active', true)->orderBy('sort_order')->get();
        return view('home.index', compact('plans'));
    }

    public function hosting()
    {
        $plans = Plan::query()->where('is_active', true)->orderBy('sort_order')->get();
        return view('home.hosting', compact('plans'));
    }

    public function domains()
    {
        $tlds = TldPricing::query()->where('is_active', true)->orderBy('tld')->get();
        return view('home.domains', compact('tlds'));
    }
}
