<?php

namespace App\Http\Controllers\Client;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index(Request $request)
    {
        $user = $request->user();

        $services = $user->services()->latest()->get();
        $invoices = $user->invoices()->latest()->limit(10)->get();

        return view('client.dashboard', compact('user', 'services', 'invoices'));
    }
}
