<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;

class SupportPinController extends Controller
{
    public function showForm(Request $request)
    {
        $this->ensureAdmin($request);
        return view('admin.support_pin');
    }

    public function lookup(Request $request)
    {
        $this->ensureAdmin($request);

        $data = $request->validate([
            'pin' => ['required', 'string', 'min:4', 'max:12'],
        ]);

        $pin = trim($data['pin']);
        $client = User::query()->where('support_pin', $pin)->where('is_admin', false)->first();

        if (!$client) {
            return back()->with('error', 'No client found for that PIN.');
        }

        return redirect()->route('admin.clients.show', $client);
    }

    private function ensureAdmin(Request $request): void
    {
        $user = $request->user();
        if (!$user || !$user->is_admin) {
            abort(403);
        }
    }
}
