<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Invoice;
use App\Models\Order;
use App\Models\Service;
use App\Models\User;
use Illuminate\Http\Request;

class DashboardController extends Controller
{
    public function index(Request $request)
    {
        $this->ensureAdmin($request);

        $stats = [
            'clients' => User::query()->where('is_admin', false)->count(),
            'services' => Service::query()->count(),
            'invoices_unpaid' => Invoice::query()->where('status', 'unpaid')->count(),
            'revenue_total' => (float) Invoice::query()->where('status', 'paid')->sum('total'),
        ];

        $recentInvoices = Invoice::query()->latest()->limit(10)->get();

        return view('admin.dashboard', compact('stats', 'recentInvoices'));
    }

    private function ensureAdmin(Request $request): void
    {
        $user = $request->user();
        if (!$user || !$user->is_admin) {
            abort(403);
        }
    }
}
