<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;

class ClientsController extends Controller
{
    public function index(Request $request)
    {
        $this->ensureAdmin($request);

        $q = trim((string) $request->query('q'));
        $clients = User::query()->where('is_admin', false)
            ->when($q !== '', function ($query) use ($q) {
                $query->where(function ($inner) use ($q) {
                    $inner->where('email', 'like', "%{$q}%")
                        ->orWhere('name', 'like', "%{$q}%")
                        ->orWhere('support_pin', 'like', "%{$q}%");
                });
            })
            ->orderByDesc('id')
            ->paginate(20)
            ->withQueryString();

        return view('admin.clients.index', compact('clients', 'q'));
    }

    public function show(Request $request, User $client)
    {
        $this->ensureAdmin($request);

        if ($client->is_admin) {
            abort(404);
        }

        $client->load(['services', 'domains', 'invoices' => function ($q) { $q->latest()->limit(20); }]);

        return view('admin.clients.show', compact('client'));
    }

    private function ensureAdmin(Request $request): void
    {
        $user = $request->user();
        if (!$user || !$user->is_admin) {
            abort(403);
        }
    }
}
