# ClubHoster (Laravel) – Billing + Hosting Checkout (Plugin-Based)

This ZIP contains a **Laravel overlay** (app code, migrations, views, assets, bundled plugins) for the “ClubHoster” billing system.

It includes:
- One-page checkout: **Domain + Hosting + Signup + Payment**
- Client Area (Billing panel) with invoices, services, and **Support PIN**
- Admin Panel (unique UI) with clients, invoices, plans, Support PIN lookup
- **Plugin system** (enable/disable/install plugins from Admin)
- Payment gateways as plugins: **JazzCash (MWallet), Stripe, PayPal**
- Automation plugins (optional): **NameSilo domain automation**, **cPanel/WHM hosting provisioning**
- ClientExec data migration command (import users, invoices, transactions, domains)
- New SQL reference file: `overlay/database/sql/clubhoster_schema.sql`

---

## 1) Requirements

- PHP 8.2+ (recommended)
- Composer
- MySQL / MariaDB
- Laravel 10+ or 11 (recommended)

---

## 2) Install (Recommended)

1. Create a new Laravel project:

```bash
composer create-project laravel/laravel clubhoster
```

2. Copy the overlay into the Laravel project root (merge & overwrite when asked):

```bash
cp -R overlay/* clubhoster/
```

3. Configure `.env` inside `clubhoster/`:

```env
APP_NAME=ClubHoster
APP_URL=https://your-domain.com

DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=clubhoster
DB_USERNAME=root
DB_PASSWORD=

CLUBHOSTER_BRAND_NAME=ClubHoster
CLUBHOSTER_CURRENCY=PKR
CLUBHOSTER_TAX_PERCENT=0

# Admin seed
CLUBHOSTER_ADMIN_EMAIL=admin@clubhoster.com
CLUBHOSTER_ADMIN_PASSWORD=ChangeMe123!
```

4. Run migrations + seed:

```bash
php artisan migrate
php artisan db:seed
```

5. Start locally (dev):

```bash
php artisan serve
```

---

## 3) URLs

- Website: `/`
- Hosting Plans: `/hosting`
- Domain Search: `/domain`
- One Page Checkout: `/checkout`
- Client Dashboard: `/client/dashboard`
- Admin Dashboard: `/admin/dashboard`
- **Admin Plugins**: `/admin/plugins`

---

## 4) Plugin System

Plugins are located in:

- `plugins/<plugin_slug>/`

Each plugin includes:
- `plugin.json`
- `bootstrap.php`

Admin can:
- Upload a new plugin ZIP
- Enable / Disable
- Run migrations (when a plugin ships DB migrations)
- Configure plugin settings (stored in `plugin_settings` with optional encryption)

---

## 5) Payment Gateways (Plugins)

Bundled gateway plugins:
- `jazzcash_gateway`
- `stripe_gateway`
- `paypal_gateway`

Enable/configure them from:

- **Admin → Plugins**

Notes:
- Checkout shows only gateways that are **enabled AND configured**.
- Stripe/PayPal use hosted checkout (redirect) and return to:
  - `/payments/{gateway}/return?invoice=...&ptoken=...`

---

## 6) Automation Plugins (Optional)

Bundled automation plugins:
- `namesilo_registrar` (domain registration + optional nameserver setting)
- `cpanel_automation` (WHM API provisioning)

Enable them only after you add credentials in **Admin → Plugins**.

---

## 7) Support PIN (Live Chat Verification)

- Every client gets a **unique Support PIN**.
- Client dashboard shows the PIN.
- Admin can verify PIN from: **Admin → Support PIN Lookup**.

---

## 8) ClientExec Data Migration

This system includes an import command:

```bash
php artisan clubhoster:import-clientexec --dry-run
```

When ready:

```bash
php artisan clubhoster:import-clientexec
```

Add these variables in `.env` to connect to your old ClientExec DB:

```env
CLIENTEXEC_DB_HOST=127.0.0.1
CLIENTEXEC_DB_PORT=3306
CLIENTEXEC_DB_DATABASE=old_clientexec_db
CLIENTEXEC_DB_USERNAME=root
CLIENTEXEC_DB_PASSWORD=
CLIENTEXEC_DB_PREFIX=
```

Importer will try to map (when tables exist):
- `users`
- `invoice`, `invoiceentry`, `invoicetransaction`
- `domains`

If some tables/columns do not exist, import skips them safely and continues.

---

## 9) Notes

- Bundled plugin loader: `App\Services\Plugins\PluginLoader`
- Payment gateway interface: `App\Services\Payments\PaymentGatewayInterface`
- Hooks: `App\Services\Hooks\HookManager` (`invoice.paid` hook is fired after successful payment)
- This overlay does **not** include Laravel `vendor/` (standard practice). Run `composer install` on your server.

---

## 10) What Was Removed

- Old ClientExec front-end billing UI is not used in this Laravel version.
- The new system provides a clean billing panel + admin panel while keeping the general website style (Poppins, existing CSS assets copied to `/public`).
